<html>
 <head> 
  <meta charset="utf-8"> 
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1"> 
  <title>Tasks</title> 
  <link rel="stylesheet" href="/mbtech/layui.css"> 
  <link rel="stylesheet" href="/mbtech/common.css"> 
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.5.7/css/layui.min.css">
  <style>

        .invite_btn{
            width: 47%;
            height: 40px;
            text-align: center;
            line-height: 40px;
            background: #396ED1;
            border-radius: 100px 100px 100px 100px;
            cursor: pointer;
        }
        .copy_link_btn{
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 14px;
            color: #FFFFFF;

        }
        .qr_code_btn{
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 14px;
            color: #FFFFFF;
            background: #29BE71;

        }
        .label{
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 14px;
            color: #95FCBE;
            line-height: 22px;
        }
        .value{
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 24px;
            color: #FFFB00;
            line-height: 28px;
        }
        .common_card .title{
            padding-left: 10px;
            font-family: Arial, Arial;
            font-weight: 700;
            font-size: 18px;
            color: #0F7A5A;
            height: 30px;
            line-height: 30px;
            display: flex;
            justify-content:space-between ;
        }
        .reward_card{
            height: auto;
            background-size: 100%;
            background-repeat: no-repeat;
            border-radius: 15px;

        }

        .reward_icon{
            height: 30px;
            width: 30px;
        }
        .reward_card .title{
           padding-left: 15px;
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 18px;
            color: #333333;
        }
        .reward_card .label{
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 14px;
            color: #333333;
            line-height: 16px;
        }
        .reward_card .value{
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 16px;
            color: #333333;
            line-height: 18px;
        }
        .reward_card .content{
            margin-bottom: 15px;
            margin-top: unset;
            width: 100%;
        }
        .reward_text{
            margin-top: 10px;
            font-family: Arial, Arial;
            font-weight: 400;
            font-size: 14px;
            color: #666666;
            line-height: 24px;
        }
       .reward_btn{
           margin-top: 4px;
           width: 100px;
           height: 34px;
           background: #FFFFFF;
           border-radius: 100px 100px 100px 100px;
           border: 1px solid #155CCD;
           font-family: Arial, Arial;
           font-weight: 400;
           font-size: 14px;
           color: #155CCD;
           line-height: 34px;
           text-align: center;
       }

    </style> 
 </head> 
 <body class="common_body" style="    background-image: url(/mbtech/mb/bg99.png);"> 
  <div class="common_header" style="height: 150px;"> 
   <a href="javascript:history.back(-1)" class="back position"> <p class="btn"><i class="layui-icon layui-icon-left layui-font-20"></i></p> Tasks </a> 
   <div class="flex_space" style="text-align: center;margin-top: 40px;"> 
    @php
  $user = auth()->user();

  // Total invited users
  $invites = \App\Models\User::where('ref_by', $user->ref_id)->count();

  // Total activated users (investor = 1)
  $activations = \App\Models\User::where('ref_by', $user->ref_id)
                  ->where('investor', 1)
                  ->count();
@endphp

<div class="flex_space" style="text-align: center; margin-top: 40px;">
  <div style="width: 33%">
    <p class="value">{{ $invites }}</p>
    <p class="label">Number of Invitations</p>
  </div>
  <div style="width: 33%">
    <p class="value">{{ $activations }}</p>
    <p class="label">Number of Activations</p>
  </div>
</div>

    <!--<div style="width: 33%"> 
     <p class="value">1</p> 
     <p class="label">Number of Invitations</p> 
    </div> 
    <div style="width: 33%"> 
     <p class="value">0</p> 
     <p class="label">Number of Activations</p> 
    </div>
   </div> -->
  </div>
  <div style="padding: 15px; margin-bottom: 100px; margin-top: 70px;">
  <div class="common_card">
    <div class="title" style="padding-left:0px">
      Sign in to receive rewards
    </div>
    <div class="desc" style="margin: 10px 0;">
      Daily check-in can receive R{{ setting('checkin') }}.
    </div>
    <div class="go_lottery layui-btn layui-btn-normal layui-btn-radius" id="sign_in" style="text-align:center" onclick="checkin()">
      Sign in now
    </div>
    <a href="#" class="go_lottery layui-btn layui-btn-primary layui-btn-radius" style="text-align:center"> Sign In Record </a>
  </div>

  <div class="common_card" style="margin-bottom: 0px">
    <div class="flex_left">
      <div class="title">Invitation and Activation</div>
    </div>
    <p class="reward_text">If your friend upgrades to VIP1 or higher, you will receive a <strong style="font-size: 1.2rem;">R20</strong> reward</p>
  </div>
 
 <div class="reward_card">
  <div style="border-radius: 15px; margin-top: 15px;">
    @php
      $tasks = \App\Models\Task::orderBy('id')->get();
      $completedTasks = \App\Models\TaskRequest::where('user_id', auth()->id())
                        ->where('status', '!=', 'rejected')
                        ->pluck('task_id')->toArray();

      // ✅ Total active referrals (investor = 1)
      $invitedCount = \App\Models\User::where('ref_by', auth()->user()->ref_id)
                        ->where('investor', 1)
                        ->count();

      $canShowNext = true;
    @endphp

    @foreach($tasks as $element)
      @php
        $isCompleted = in_array($element->id, $completedTasks);
        $target = $element->team_size ?? 1;
        $percentage = min(100, round(($invitedCount / $target) * 100));
      @endphp

      <div style="background: #FFFFFF; padding: 15px; border-radius: 15px; margin-bottom: 15px;">
        <div class="content flex_space">
          <div class="flex_left" style="width: 52px;">
            <img src="/public/site/img/tasks/reward_icon.png" style="width: 52px;height: 52px;">
            <div>
              <p style="margin-top:5px; font-size: 14px; color: #F76C2B;">
                {{ price($element->bonus) }}
              </p>
              <p style="font-size: 14px; color: #888888;">Reward</p>
            </div>
          </div>

          {{-- ✅ Task Button Logic --}}
          @if($isCompleted)
            <button class="reward_btn" style="opacity: 0.5; cursor: default;">Completed</button>
          @elseif($invitedCount >= $target && $canShowNext)
            <button onclick="getDeposirreward('{{ url('apply-for-task-commission/' . $element->id) }}')" class="reward_btn">Receive</button>
            @php $canShowNext = false; @endphp
          @elseif($canShowNext)
            <a href="/invitation" class="reward_btn"> Invite </a>
            @php $canShowNext = false; @endphp
          @else
            <button class="reward_btn" style="opacity: 0.3; cursor: not-allowed;">Locked</button>
          @endif
        </div>

        <div style="margin-top: 10px;">
          <div class="label" style="margin-bottom: 10px;">
            Invite {{ $target }} new active users to unlock {{ price($element->bonus) }} reward
          </div>
          <div class="flex_space">
            <div class="layui-progress" style="width: 80%; height: 10px;">
              <div class="layui-progress-bar layui-bg-blue"
                   style="height: 10px; background: linear-gradient(90deg, #FFDA57 0%, #FFB943 100%); width: {{ $percentage }}%;">
              </div>
            </div>
            <div class="value">
              <span style="color: #359B5A">{{ $invitedCount }}</span> / {{ $target }}
            </div>
          </div>
        </div>
      </div>
    @endforeach
  


  
       <!-- @php
  $tasks = \App\Models\Task::orderBy('id')->get();
  $completedTasks = \App\Models\TaskRequest::where('user_id', auth()->id())
                    ->where('status', '!=', 'rejected')
                    ->pluck('task_id')->toArray();
@endphp

@foreach($tasks as $element)
  @php
    $isCompleted = in_array($element->id, $completedTasks);
    $applyCount = \App\Models\TaskRequest::where('task_id', $element->id)
                  ->where('user_id', auth()->id())
                  ->where('status', '!=', 'rejected')->count();
    $target = $element->team_size ?? 1;
    $percentage = min(100, round(($applyCount / $target) * 100));
  @endphp

  <div style="background: #FFFFFF; padding: 15px; border-radius: 15px; margin-bottom: 15px;">
    <div class="content flex_space">
      <div class="flex_left" style="width: 52px;">
        <img src="/public/site/img/tasks/reward_icon.png" style="width: 52px;height: 52px;">
        <div>
          <p style="margin-top:5px; font-size: 14px; color: #F76C2B;">
            {{ price($element->bonus) }}
          </p>
          <p style="font-size: 14px; color: #888888;">Reward</p>
        </div>
      </div>

      {{-- ✅ BUTTON CONDITIONS --}}
      @if($isCompleted)
        <button class="reward_btn" style="opacity: 0.5; cursor: default;">Completed</button>
      @elseif($applyCount >= $target)
        <button onclick="getDeposirreward('{{ url('apply-for-task-commission/' . $element->id) }}')" class="reward_btn">Receive</button>
      @else
        <a href="/invitation" class="reward_btn"> Invite </a>
      @endif
    </div>

    <div style="margin-top: 10px;">
      <div class="label" style="margin-bottom: 10px;">
        Invite {{ $target }} new users to activate a reward of {{ price($element->bonus) }}
      </div>
      <div class="flex_space">
        <div class="layui-progress" style="width: 80%; height: 10px;">
          <div class="layui-progress-bar layui-bg-blue"
               style="height: 10px; background: linear-gradient(90deg, #FFDA57 0%, #FFB943 100%); width: {{ $percentage }}%;">
          </div>
        </div>
        <div class="value">
          <span style="color: #359B5A">{{ $applyCount }}</span> / {{ $target }}
        </div>
      </div>
    </div>
  </div>
@endforeach-->

    </div>
  </div>
</div>
  <!--<a href="/help"  id="service" style="background:#ffffff">--> 
  <!--  <img src="/public/site/img/common/service.png" style="width: 40px;height: 40px">--> 
  <!--</a>--> 
  <!--<a href="/lottery"  id="lottery" class="animate__animated animate__fadeInUp" style=" position: fixed;   z-index:9999;   bottom: 200px;   left: 0px;">--> 
  <!--    <img src="/public/site/img/common/lottery.png" style="width: 40px;height: 40px">--> 
  <!--</a>--> 
  <div class="footer_menu"> 
   <div class="content"> 
    <a href="/" class="item "> <img src="/mbtech/mb/home.png"> <p>Home</p> </a> 
    <a href="/blog" class="item "> <img src="/mbtech/blog.png"> <p>Blog</p> </a> 
    <a href="/invitation" class="item "> <img src="/mbtech/mb/invest.png"> <p>Team</p> </a> 
    <a href="/tasks" class="item active"> <img src="/mbtech/tasks.png"> <p>Tasks</p> </a> 
    <a href="/my" class="item "> <img src="/mbtech/my.png"> <p>My</p> </a> 
   </div> 
  </div>
  @include('alert-message')
  <textarea style="height: 1px;opacity: 0" name="copyTxt" id="copyTxt" readonly>https://namaskar.cc/?invitation_code=F492A</textarea> 
  <!-- Body Ending with layui --> 
  <div class="loader" style="
    position: fixed;
    display: none;
    top: 50%;
    z-index: 99;
    width: 143px;
    border-radius: 15px;
    overflow: hidden;
    left: 50%;
    transform: translate(-50%, -50%);
">
    <img src="{{asset('public/loading.gif')}}" style="width: 100%;" alt="">
</div>

@include('alert-message')
<script>
    function copyLink(text)
    {
        const body = document.body;
        const input = document.createElement("input");
        body.append(input);
        input.style.opacity = 0;
        input.value = text.replaceAll(' ', '');
        input.select();
        input.setSelectionRange(0, input.value.length);
        document.execCommand("Copy");
        input.blur();
        input.remove();
        message('Copied success..')
    }

    function receivedReward(condition){
        if (condition == true){
            window.location.href='{{route('user.received.reward')}}';
        } else {
            message('Target not eligible.')
        }
    }

    // ✅ RENAMED FUNCTION
    function checkin(){
        // Show loader if needed
        //document.querySelector('.loading').style.display = 'block';
        window.location.href='{{route('user.checkin')}}';
    }

    function closeCheckIn(){
        var checkinOverLay = document.querySelector('.checkinOverLay');
        var checkinOverBlock = document.querySelector('.checkinOverBlock');
        checkinOverLay.style.display = 'none';
        checkinOverBlock.style.display = 'none';
    }

    function openCheckIn(){
        var checkinOverLay = document.querySelector('.checkinOverLay');
        var checkinOverBlock = document.querySelector('.checkinOverBlock');
        checkinOverLay.style.display = 'block';
        checkinOverBlock.style.display = 'block';
    }

    // ✅ Second function stays unchanged but renamed if needed later
    function submitBonusCode(){
        closeCheckIn()
        var code = document.querySelector('input[name="code"]').value;
        window.location.href='{{url('submit-bonus-amount')}}' + "/" + code
    }

    function getDeposirreward(url){
        document.querySelector('.loader').style.display = 'block';
        window.location.href = url
    }
</script>

</body>
</html>